/* @(#) somx/prf.c 2.3 1/20/94 10:18:01 [5/15/94 17:58:59] */

/*
 * 96F8647, 96F8648, 96F8850 (C) Copyright IBM Corp. 1992, 1994
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * DISCLAIMER OF WARRANTIES.
 * The following [enclosed] code is sample code created by IBM
 * Corporation. This sample code is not part of any standard or IBM
 * product and is provided to you solely for the purpose of assisting
 * you in the development of your applications.  The code is provided
 * "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
 * THIS CODE.  IBM shall not be liable for any damages arising out of
 * your use of the sample code, even if they have been advised of the
 * possibility of such damages.
 *
 * DISTRIBUTION.
 * This sample code can be freely distributed, copied, altered, and
 * incorporated into other software, provided that it bears the above
 * Copyright notice and DISCLAIMER intact.
 */


/*===========================================================================*
 *                                                                           *
 * Name: prf.c                                                               *
 *                                                                           *
 * Notes: This module is the implementation of a SOM Persistence             *
 * Media Interface class. It provides an interface to OS/2 INI files.        *
 *                                                                           *
 * History:                                                                  *
 * 4/2/93    : version 1                                                     *
 *                                                                           *
 *===========================================================================*/

#include<stdlib.h>
#include<stdio.h>
#include<string.h>

#define PRFBLOCK_SIZE 1024

#ifdef __OS2__
#define INCL_WINWINDOWMGR    /* Or use INCL_WIN or INCL_PM. Also in COMMON section */
#define INCL_WINSHELLDATA  /* Or use INCL_WIN or INCL_PM */
#include <os2.h>
#else
/* Stubs of OS/2 prf calls */
#include <prfstub.h>
#endif

#include <somp.h>
#include <string.h>
#include <memory.h>

#define SOMPIniMediaInterface_Class_Source
#include <prf.ih>

/* set the target string t with the given string g */
static string cpyString(string *t, string g)
{
    if (*t) SOMFree(*t);
    *t = (string)SOMMalloc(strlen(g) + 1);
    strcpy(*t, g);
    return(*t);
}


/*
 *  Method to begin a block of data
 */

SOM_Scope void  SOMLINK sompBeginBlock(SOMPIniMediaInterface somSelf, Environment *ev,
                string appName,
                string key)
{
    BOOL    fSuccess;   /* Success indicator */
    ULONG   dataLen = 0;
    SOMPIniMediaInterfaceData *somThis = SOMPIniMediaInterfaceGetData(somSelf);
    SOMPIniMediaInterfaceMethodDebug("SOMPIniMediaInterface","sompBeginBlock");

    if (_block) {
      SOMFree(_block);
    } /* endif */
    cpyString(&_appName, appName);
    cpyString(&_key, key);
    fSuccess = PrfQueryProfileSize(_hini, _appName, _key, &dataLen);
    if (dataLen == 0) {             /* No data by that name          */
       _block = (string)SOMMalloc(PRFBLOCK_SIZE);
       _blockSize = PRFBLOCK_SIZE;
       memset((void*)_block, 0, (size_t)_blockSize);
       _readPtr = _blockSize;       /* nothing to read               */
       _writePtr = 0;
    } else {
       _block = (string)SOMMalloc(dataLen);
       fSuccess = PrfQueryProfileData(_hini, _appName, _key, _block, &dataLen);
       _blockSize = dataLen;
       _readPtr = 0;                /* can read from 0 to blockSize  */
       _writePtr = 0;
    } /* endif */
}

/*
 *  Flushes buffered data to the profile
 */

SOM_Scope void  SOMLINK sompEndBlock(SOMPIniMediaInterface somSelf, Environment *ev)
{
    BOOL   fSuccess; /* Success indicator */
    SOMPIniMediaInterfaceData *somThis = SOMPIniMediaInterfaceGetData(somSelf);
    SOMPIniMediaInterfaceMethodDebug("SOMPIniMediaInterface","sompEndBlock");

    if (_writePtr) {
       fSuccess = PrfWriteProfileData(_hini, _appName, _key, _block, (ULONG)_writePtr);
    } /* endif */
}

SOM_Scope void  SOMLINK sompInitReadWrite(SOMPIniMediaInterface somSelf, Environment *ev,
                string mediaInfo)
{
    SOMPIniMediaInterfaceData *somThis = SOMPIniMediaInterfaceGetData(somSelf);
    SOMPIniMediaInterfaceMethodDebug("SOMPIniMediaInterface","sompInitReadWrite");

    cpyString(&_fileName, mediaInfo);
}

SOM_Scope void  SOMLINK sompInitReadOnly(SOMPIniMediaInterface somSelf, Environment *ev,
                string mediaInfo)
{
    SOMPIniMediaInterfaceData *somThis = SOMPIniMediaInterfaceGetData(somSelf);
    SOMPIniMediaInterfaceMethodDebug("SOMPIniMediaInterface","sompInitReadOnly");

    _sompInitReadWrite(somSelf, ev, mediaInfo);/* No readonly support
                                       for this version              */
}

static char userPrf[80]="os2.ini";
static char sysPrf[80]="os2sys.ini";
static PRFPROFILE p = {
   sizeof(userPrf), userPrf,
   sizeof(sysPrf), sysPrf };

/* Assume that if they give os2.ini then use USERPROFILE */
/* Assume that if they give os2sys.ini then use SYSTEMPROFILE */
SOM_Scope void  SOMLINK sompOpen(SOMPIniMediaInterface somSelf, Environment *ev)
{
    BOOL   fSuccess; /* Success indicator */
    SOMPIniMediaInterfaceData *somThis = SOMPIniMediaInterfaceGetData(somSelf);
    SOMPIniMediaInterfaceMethodDebug("SOMPIniMediaInterface","sompOpen");

    if (_fileName) {
       /* fSuccess = PrfQueryProfile(_hab, &p); */
#ifdef __OS2__
       if (stricmp(_fileName, userPrf)==0)
#else
       if (strcmp(_fileName, userPrf)==0)
#endif
       {
          _hini = HINI_USERPROFILE; /* No need to open */
       } else {
#ifdef __OS2__
          if (stricmp(_fileName, sysPrf)==0)
#else
          if (strcmp(_fileName, sysPrf)==0)
#endif
          {
             _hini = HINI_SYSTEMPROFILE;
          } else {
             _hini = PrfOpenProfile(_hab, _fileName);
          }
       }
    } /* endif */
}

SOM_Scope void  SOMLINK sompClose(SOMPIniMediaInterface somSelf, Environment *ev)
{
    BOOL  fSuccess;/* Success indicator */
    Environment tev;
    SOMPIniMediaInterfaceData *somThis = SOMPIniMediaInterfaceGetData(somSelf);
    SOMPIniMediaInterfaceMethodDebug("SOMPIniMediaInterface","sompClose");

    if (_hini) {
       fSuccess = PrfCloseProfile(_hini);
       _hini = NULL;
       _sompBeginBlock(somSelf, &tev, "$$SOMP$$", "key");
    } /* endif */
}

SOM_Scope void  SOMLINK sompSeekPosition(SOMPIniMediaInterface somSelf, Environment *ev,
                long offset)
{
    SOMPIniMediaInterfaceData *somThis = SOMPIniMediaInterfaceGetData(somSelf);
    SOMPIniMediaInterfaceMethodDebug("SOMPIniMediaInterface","sompSeekPosition");

    _readPtr = offset;
}

SOM_Scope void  SOMLINK sompSeekPositionRel(SOMPIniMediaInterface somSelf, Environment *ev,
                long offset)
{
    SOMPIniMediaInterfaceData *somThis = SOMPIniMediaInterfaceGetData(somSelf);
    SOMPIniMediaInterfaceMethodDebug("SOMPIniMediaInterface","sompSeekPositionRel");

    _readPtr += offset;
}

SOM_Scope long  SOMLINK sompGetOffset(SOMPIniMediaInterface somSelf, Environment *ev)
{
    SOMPIniMediaInterfaceData *somThis = SOMPIniMediaInterfaceGetData(somSelf);
    SOMPIniMediaInterfaceMethodDebug("SOMPIniMediaInterface","sompGetOffset");

    return((long)_readPtr);
}

SOM_Scope void  SOMLINK sompReadBytes(SOMPIniMediaInterface somSelf, Environment *ev,
                string byteStream,
                long length)
{
    long amountToRead = 0;
    SOMPIniMediaInterfaceData *somThis = SOMPIniMediaInterfaceGetData(somSelf);
    SOMPIniMediaInterfaceMethodDebug("SOMPIniMediaInterface","sompReadBytes");

    if (_blockSize) {
       amountToRead = ((_readPtr + length) <= _blockSize) ?
                      length :
                      _blockSize - _readPtr;

       if (amountToRead) {
          memcpy((void*)byteStream, (void*)(_block+_readPtr), (size_t)amountToRead);
          _readPtr += amountToRead;
       } else {
          /* Nothing to read                                            */
       } /* endif */
    } else {
       /* Nothing to read                                            */
    } /* endif */
}

SOM_Scope void  SOMLINK sompWriteBytes(SOMPIniMediaInterface somSelf, Environment *ev,
                string byteStream,
                long length)
{
    SOMPIniMediaInterfaceData *somThis = SOMPIniMediaInterfaceGetData(somSelf);
    SOMPIniMediaInterfaceMethodDebug("SOMPIniMediaInterface","sompWriteBytes");

    if (_blockSize) {
       if (_writePtr + length > _blockSize) {
          _blockSize += (PRFBLOCK_SIZE + length);
          _block = SOMRealloc(_block, _blockSize);
       } /* endif */
       memcpy((void*)(_block+_writePtr), (void*)byteStream, (size_t)length);
       _writePtr += length;
    } else {
       /* No place to write                                          */
    } /* endif */

}

SOM_Scope void  SOMLINK sompWriteCharacter(SOMPIniMediaInterface somSelf, Environment *ev,
                char c)
{
    SOMPIniMediaInterfaceData *somThis = SOMPIniMediaInterfaceGetData(somSelf);
    SOMPIniMediaInterfaceMethodDebug("SOMPIniMediaInterface","sompWriteCharacter");

   _sompWriteBytes(somSelf, ev,  &c, 1);
}

SOM_Scope void  SOMLINK sompReadCharacter(SOMPIniMediaInterface somSelf, Environment *ev,
                string c)
{
    SOMPIniMediaInterfaceData *somThis = SOMPIniMediaInterfaceGetData(somSelf);
    SOMPIniMediaInterfaceMethodDebug("SOMPIniMediaInterface","sompReadCharacter");

   _sompReadBytes(somSelf, ev, c, 1);
}


SOM_Scope void  SOMLINK somInit(SOMPIniMediaInterface somSelf)
{
    static int firsttime = 1;
    Environment *ev;
    SOMPIniMediaInterfaceData *somThis = SOMPIniMediaInterfaceGetData(somSelf);
    SOMPIniMediaInterfaceMethodDebug("SOMPIniMediaInterface","somInit");

    if (firsttime) {
       _hab = WinInitialize(0L);
       firsttime = 0;
    } /* endif */

    _fileName = NULL;
    _hini = NULL;
    ev = SOM_CreateLocalEnvironment();
    _sompBeginBlock(somSelf, ev, "$$SOMP$$", "key");
    SOM_DestroyLocalEnvironment(ev);
}

SOM_Scope void  SOMLINK somUninit(SOMPIniMediaInterface somSelf)
{
    SOMPIniMediaInterfaceData *somThis = SOMPIniMediaInterfaceGetData(somSelf);
    SOMPIniMediaInterfaceMethodDebug("SOMPIniMediaInterface","somUninit");

    if (_block) {
       SOMFree(_block);
    } /* endif */
}

/*
 *  Method to check for the existence of a block of data.
 */

SOM_Scope boolean  SOMLINK sompBlockExists(SOMPIniMediaInterface somSelf, Environment *ev,
                string appName,
                string key)
{
    BOOL    fSuccess;   /* Success indicator */
    ULONG   dataLen = 0;
    SOMPIniMediaInterfaceData *somThis = SOMPIniMediaInterfaceGetData(somSelf);
    SOMPIniMediaInterfaceMethodDebug("SOMPIniMediaInterface","sompBeginBlock");

    fSuccess = PrfQueryProfileSize(_hini, appName, key, &dataLen);
    if (!fSuccess || dataLen == 0) {             /* No data by that name */
       return(FALSE);
    } else {
       return(TRUE);
    } /* endif */
}
